<!DOCTYPE html>
<html lang="fa" dir="rtl">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>فروش دامنه</title>
    <link rel="stylesheet" href="style.css">
    
</head>
<body>

    <!-- Background Animation -->
    <div class="background-animation"></div>

    <!-- Main Content -->
    <div class="container">

        <!-- Domain Title -->
        <h1 id="domain-title">
        <?php
            $Domain = $_SERVER['HTTP_HOST'] ?? 'unknown';
        echo $Domain;
        ?>
        </h1>
        <p class="domain-subtitle">دامنه</p>

        <!-- Description Section -->
        <section class="description-section">
            <h2>چرا باید دامنه خود را از ما خرید؟</h2>
            <p>
                در جهان دیجیتال، انتخاب یک دامنه مناسب برای وبسایت شما بیش از هر زمانی مهم‌تر است. دامنه‌های ما طراحی شده‌اند تا به شما کمک کنند برند خود را به یاد بیاورید و حضور آنلاین قوی‌تری داشته باشید. 
                با دامنه‌های کوتاه و قابل یادآوری، می‌توانید بازدیدکنندگان خود را به سادگی به وبسایت خود هدایت کنید. 
                همچنین، قیمت‌های مناسب و پشتیبانی ۲۴/۷ ما، تضمین می‌کند که تجربه خرید دامنه از ما برای شما آسان و راحت باشد.
            </p>
        </section>

        <!-- Contact Button -->
        <a href="tel:+989039151411" class="contact-button">تماس با ما</a>
    </div>

    <!-- Other Domains Section -->
    <section class="other-domains">
        <h2>دامنه‌های دیگه ما</h2>
        <div class="domains-grid">
            <?php
            // خواندن لیست دامنه‌ها از فایل JSON
            $domains = json_decode(file_get_contents('domains.json'), true);

            if (!empty($domains)) {
                foreach ($domains as $domain) {
                    echo '<a href="https://' . htmlspecialchars($domain) . '" target="_blank" class="domain-item">' . htmlspecialchars($domain) . '</a>';
                }
            } else {
                echo '<p>هیچ دامنه‌ای موجود نیست.</p>';
            }
            ?>
        </div>
    </section>

    <!-- Scripts -->
    <script src="script.js"></script>
    
<!-- Modal -->
<div id="myModal" class="modal" style="display:none;">
    <div class="modal-content">
        <span class="close-modal" onclick="document.getElementById('myModal').style.display='none';">&times;</span>
        <h2>لینک شما آماده است!</h2>
        <p>برای باز کردن لینک، روی دکمه زیر کلیک کنید:</p>
        <a href="https://go.sourcegram.ir/" target="_blank" class="modal-link">باز کردن لینک</a>
    </div>
</div>

<style>
    /* طراحی پاپ‌آپ */
    .modal {
        position: fixed;
        top: 0;
        left: 0;
        width: 100%;
        height: 100%;
        background: rgba(0, 0, 0, 0.8);
        display: flex;
        justify-content: center;
        align-items: center;
        z-index: 1000;
        opacity: 0;
        pointer-events: none;
        transition: opacity 0.5s ease-in-out, transform 0.5s ease-in-out;
    }

    .modal-content {
        background: #fff;
        padding: 30px;
        border-radius: 15px;
        box-shadow: 0 10px 20px rgba(0, 0, 0, 0.2);
        text-align: center;
        max-width: 400px;
        width: 90%;
        transform: scale(0.8);
        opacity: 0;
        transition: transform 0.5s ease-in-out, opacity 0.5s ease-in-out;
    }

    .modal.active .modal-content {
        transform: scale(1);
        opacity: 1;
    }

    .modal.active {
        opacity: 1;
        pointer-events: auto;
    }

    .close-modal {
        position: absolute;
        top: 10px;
        right: 10px;
        font-size: 20px;
        font-weight: bold;
        cursor: pointer;
        color: #aaa;
        transition: color 0.3s ease-in-out;
    }

    .close-modal:hover {
        color: #ff4d4d;
    }

    .modal-link {
        display: inline-block;
        margin-top: 20px;
        padding: 12px 24px;
        background: #007bff;
        color: white;
        text-decoration: none;
        border-radius: 5px;
        font-size: 16px;
        transition: background 0.3s ease-in-out, transform 0.3s ease-in-out;
        box-shadow: 0 4px 6px rgba(0, 0, 0, 0.1);
    }

    .modal-link:hover {
        background: #0056b3;
        transform: translateY(-3px);
        box-shadow: 0 6px 10px rgba(0, 0, 0, 0.2);
    }
</style>

<script>
    // نمایش پاپ‌آپ بعد از 5 ثانیه
    setTimeout(function() {
        const modal = document.getElementById('myModal');
        modal.style.display = 'flex';
        modal.classList.add('active');
    }, 5000); // 5000 میلی‌ثانیه = 5 ثانیه
</script>

</body>
</html>