// Smooth Scrolling for Links
document.querySelectorAll('a[href^="#"]').forEach(anchor => {
    anchor.addEventListener('click', function (e) {
        e.preventDefault();

        document.querySelector(this.getAttribute('href')).scrollIntoView({
            behavior: 'smooth'
        });
    });
});

// Parallax Effect for Background
window.addEventListener('scroll', function () {
    const background = document.querySelector('.background-animation');
    background.style.transform = `translateY(${window.scrollY * 0.5}px)`;
});